/*
 * Decompiled with CFR 0.152.
 */
package quentinc.speechconf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;

public class Main {
    public static void copy(URL uRL, File file) throws IOException {
        Main.copy(uRL.openStream(), file, false);
    }

    public static void copy(File file, File file2) throws IOException {
        Main.copy(new FileInputStream(file), file2, true);
    }

    public static void copy(InputStream inputStream, File file, boolean bl) throws IOException {
        int n;
        String string = "";
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[4096];
        int n2 = 0;
        long l = System.currentTimeMillis();
        while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
            n2 += n;
            if (bl) continue;
            for (int i = 0; i < string.length(); ++i) {
                System.out.print('\b');
            }
            string = String.format("%6.0fKB downloaded. Speed : %8.2fKB/s", (double)n2 / 1024.0, 1.0 * (double)n2 / (double)(System.currentTimeMillis() - l));
            System.out.print(string);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        if (!bl) {
            System.out.println();
        }
    }

    public static boolean classExists(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Serializable serializable4;
        int n;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = System.getProperty("java.ext.dirs");
        int n2 = string.indexOf(59);
        string = n2 >= 0 ? string.substring(0, n2) : string;
        File file = new File(string);
        System.out.println("Welcome to the speech configurator.\r\nThis program will help you to configure speech output for QuentinC's games");
        System.out.println("Press enter to continue...");
        bufferedReader.readLine();
        String string2 = System.getProperty("os.name").trim().toLowerCase();
        String[] stringArray2 = new String[]{"SAPI5\t\tWindows only", "Eloquence speech\t\tWindows and linux", "Native jaws support\t\tWindows only, heavy discouraged", "Speech dispatcher", "Free TTS / Java speech API", "Custom command line program with stdin support", "Custom speaking server with TCP/IP support"};
        String[] stringArray3 = new String[]{"sapi", "eci", "jfw", "speechd", "freetts", "cmdproc", "cmdsocket"};
        String[][] stringArrayArray = new String[][]{new String[0], {"language", "volume", "rate", "pitch", "pitchFluctuation", "gender", "headSize", "roughness", "breathiness"}, new String[0], {"application", "component", "user", "host", "port", "outputModule", "language", "voice", "synthesisVoice", "priority", "pitch", "rate", "volume"}, {"voiceGender", "voiceAge", "voiceName", "voiceStyle", "engine"}, {"command", "initializingCommands", "rate", "volume", "cmd_say", "cmd_sayInterrupt", "cmd_pause", "cmd_resume", "cmd_setRate", "cmd_getRate", "cmd_setVolume", "cmd_getVolume", "minVolume", "maxVolume", "minRate", "maxRate"}, {"host", "port", "initializingCommands", "rate", "volume", "cmd_say", "cmd_sayInterrupt", "cmd_pause", "cmd_resume", "cmd_setRate", "cmd_getRate", "cmd_setVolume", "cmd_getVolume", "minVolume", "maxVolume", "minRate", "maxRate"}, new String[0]};
        System.out.println("Please select the speech interface you want to use from the list below : ");
        for (n = 0; n < stringArray3.length; ++n) {
            System.out.printf("%d : %s%n", n + 1, stringArray2[n]);
        }
        System.out.print("Make your choice : ");
        n = Integer.parseInt(bufferedReader.readLine()) - 1;
        System.out.printf("You selected :%n%s%n", stringArray2[n]);
        if (!(n != 0 && n != 2 || string2.contains("windows"))) {
            System.out.println("WARNING : This driver is only available on windows. Do you want to continue ?\r\nType Y for yes or N for no. By answering no, no configuration will be done.");
            if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                System.exit(0);
            }
        }
        if (n == 1) {
            if (string2.contains("windows")) {
                serializable4 = new File("C:\\Program files\\freedom scientific\\shared\\eloquence\\6.1\\");
                serializable3 = new File((File)serializable4, "ECI.DLL");
                serializable2 = new File((File)serializable4, "ECI.INI");
                serializable = new File("ECI.DLL");
                Serializable serializable5 = new File("ECI.INI");
                while (!((File)serializable3).exists() && !serializable2.exists()) {
                    System.out.println("Could not find eloquence on your system. Please type in the path where eloquence is installed");
                    System.out.println("Eloquence path : <Current value : " + ((File)serializable4).getAbsolutePath() + ">");
                    System.out.print("Eloquence path : ");
                    String object22 = bufferedReader.readLine();
                    if (object22.equals("")) {
                        System.exit(0);
                    }
                    serializable4 = new File(object22);
                    serializable3 = new File((File)serializable4, "ECI.DLL");
                    serializable2 = new File((File)serializable4, "ECI.INI");
                }
                if (!serializable.exists()) {
                    Main.copy((File)serializable3, serializable);
                }
                if (!serializable5.exists()) {
                    Main.copy(serializable2, serializable5);
                }
            }
            if (!Main.classExists("com.sun.jna.Native")) {
                System.out.println("This eloquence driver requires Java Native Access (JNA) library. Do you want to download and install it now ?\r\nSize : about 900 KB\r\nSource : https://jna.dev.java.net/\r\nInstallation directory : " + file.getAbsolutePath());
                System.out.println("Type Y for yes or N for no. By answering no, nothing will be configured.");
                if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                    System.exit(0);
                }
                serializable4 = new URL("http://quentinc.net/javadl/jna.jar");
                serializable3 = new File(file, "jna.jar");
                System.out.println("Downloading jna.jar...");
                Main.copy((URL)serializable4, (File)serializable3);
            }
        }
        if (n == 0 && !((File)(serializable4 = new File("easysapi.dll"))).exists()) {
            System.out.println("This driver requires the file easysapi.dll.\r\n Do you want to download it now ?\r\nSize : about 20KB\r\nSource : http://quentinc.net/\r\nInstallation directory : " + new File(((File)serializable4).getAbsolutePath()).getParentFile().getAbsolutePath());
            System.out.println("Type Y for yes or N for no. By answering no, nothing will be configured.");
            if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                System.exit(0);
            }
            serializable3 = new URL("http://quentinc.net/javadl/easysapi.dll");
            System.out.println("Downloading " + ((File)serializable4).getName() + "...");
            Main.copy((URL)serializable3, (File)serializable4);
        }
        if (n == 2) {
            serializable4 = new File("jfwapi.dll");
            serializable3 = new File("javajfwapi.dll");
            if (!((File)serializable4).exists() || !((File)serializable3).exists()) {
                System.out.println("This driver requires the files jfwapi.dll and javajfwapi.dll. Do you want to download them now ?\r\nSize : about 25KB\r\nSource : multiple\r\nInstallation directory : " + new File(((File)serializable4).getAbsolutePath()).getParentFile().getAbsolutePath());
                System.out.println("Type Y for yes or N for no. By answering no, nothing will be configured.");
                if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                    System.exit(0);
                }
                serializable2 = new URL("http://quentinc.net/javadl/jfwapi.dll");
                serializable = new URL("http://quentinc.net/javadl/javajfwapi.dll");
                System.out.println("Downloading " + ((File)serializable4).getName() + "...");
                Main.copy((URL)serializable2, (File)serializable4);
                System.out.println("Downloading " + ((File)serializable3).getName() + "...");
                Main.copy((URL)serializable, (File)serializable3);
            }
        }
        if (n == 3 && !Main.classExists("speechd.ssip.SSIPClient")) {
            System.out.println("This driver requires the SSIP package.\r\n Do you want to download and install it now ?\r\nSize : about 40KB\r\nSource : multiple\r\nInstallation directory : " + file.getAbsolutePath());
            System.out.println("Type Y for yes or N for no. By answering no, nothing will be configured.");
            if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                System.exit(0);
            }
            serializable4 = new URL("http://quentinc.net/javadl/speechd.jar");
            serializable3 = new File(file, "speechd.jar");
            System.out.println("Downloading " + ((File)serializable3).getName() + "...");
            Main.copy((URL)serializable4, (File)serializable3);
        }
        if (n == 4 && !Main.classExists("javax.speech.Central")) {
            System.out.println("This driver requires the Free TTS package.\r\n Do you want to download and install it now ?\r\nSize : about 7.2MB\r\nSource : unknown\r\nInstallation directory : " + file.getAbsolutePath());
            System.out.println("Type Y for yes or N for no. By answering no, nothing will be configured.");
            if (!bufferedReader.readLine().toLowerCase().startsWith("y")) {
                System.exit(0);
            }
            for (Serializable serializable5 : serializable4 = new String[]{"jsapi.jar", "freetts.jar", "en_us.jar", "cmu_us_kal.jar", "cmulex.jar"}) {
                URL uRL = new URL("http://quentinc.net/javadl/" + (String)((Object)serializable5));
                object = new File(file, (String)((Object)serializable5));
                System.out.println("Downloading " + ((File)object).getName() + "...");
                Main.copy(uRL, (File)object);
            }
        }
        System.out.println("Further parameters will now be asked.\r\nIf you don't know or if you are not sure what you have to type in, just press enter.\r\nThe default value will then be used.");
        serializable4 = new Properties();
        serializable3 = Main.class.getResource("/" + stringArray3[n] + ".properties");
        if (serializable3 != null) {
            ((Properties)serializable4).load(new InputStreamReader(((URL)serializable3).openStream()));
        }
        for (String string3 : stringArrayArray[n]) {
            object = ((Properties)serializable4).getProperty(string3, null);
            if (object != null) {
                System.out.printf("%s <Default value : %s>%n%s : ", string3, object, string3);
            } else {
                System.out.print(string3 + " : ");
            }
            String string4 = bufferedReader.readLine().trim().replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
            if (string4.equals("")) continue;
            ((Properties)serializable4).setProperty(string3, string4);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("ttscfg.properties"));
        ((Properties)serializable4).store(bufferedWriter, "Speech configuration");
        ((Writer)bufferedWriter).close();
    }
}

