/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;
import quentinc.accessibility.Speech;

public class CommandLineSpeech
extends Speech {
    public static final String ln = System.getProperty("line.separator");
    private Socket sock;
    private Process proc;
    private BufferedWriter bw;
    private BufferedReader br;
    private HashMap<String, String> commands = new HashMap();
    private int rate = 0;
    private int volume = 100;

    public static Speech getInstance(Properties properties) {
        try {
            return new CommandLineSpeech(properties);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public CommandLineSpeech(Properties properties) throws IOException {
        String string = properties.getProperty("host", null);
        String string2 = properties.getProperty("command", null);
        String string3 = properties.getProperty("encoding", null);
        int n = Integer.parseInt(properties.getProperty("port", "-1"));
        if (string != null && n > 0) {
            this.sock = new Socket(string, n);
            this.bw = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream(), string3));
            this.br = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), string3));
        } else if (string2 != null) {
            this.proc = Runtime.getRuntime().exec(string2);
            this.bw = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream(), string3));
            this.br = new BufferedReader(new InputStreamReader(this.proc.getInputStream(), string3));
        } else {
            throw new IllegalArgumentException("Some parameters are missing");
        }
        String string4 = properties.getProperty("initializingCommands", null);
        if (string4 != null) {
            this.send(string4);
        }
        this.volume = Integer.parseInt(properties.getProperty("volume", "-1000000"));
        this.rate = Integer.parseInt(properties.getProperty("rate", "-1000000"));
        if (this.rate >= this.getMinRate() && this.rate <= this.getMaxRate()) {
            this.setRate(this.rate);
        } else {
            this.rate = 0;
        }
        if (this.volume >= this.getMinVolume() && this.volume <= this.getMaxVolume()) {
            this.setVolume(this.volume);
        } else {
            this.volume = 100;
        }
        for (String string5 : properties.stringPropertyNames()) {
            this.commands.put(string5, properties.getProperty(string5));
        }
    }

    public void close() {
        try {
            if (this.br != null) {
                this.br.close();
            }
            this.br = null;
            if (this.bw != null) {
                this.bw.close();
            }
            this.bw = null;
            if (this.sock != null) {
                this.sock.close();
            }
            this.sock = null;
            if (this.proc != null) {
                this.proc.destroy();
            }
            this.proc = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void finalize() {
        this.close();
    }

    public void send(String string) {
        try {
            this.bw.write(string);
            this.bw.write(ln);
            this.bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String read() {
        try {
            return this.br.readLine();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isRateAdjustable() {
        return this.commands.containsKey("cmd_setRate");
    }

    @Override
    public boolean setRate(int n) {
        Object[] objectArray = new Object[1];
        this.rate = n;
        objectArray[0] = this.rate;
        this.send(String.format(this.commands.get("cmd_setRate"), objectArray));
        return true;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public boolean isVolumeAdjustable() {
        return this.commands.containsKey("cmd_setVolume");
    }

    @Override
    public boolean setVolume(int n) {
        Object[] objectArray = new Object[1];
        this.volume = n;
        objectArray[0] = this.volume;
        this.send(String.format(this.commands.get("cmd_setVolume"), objectArray));
        return true;
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public int getMinVolume() {
        if (this.commands.containsKey("minVolume")) {
            return Integer.parseInt(this.commands.get("minVolume"));
        }
        return 0;
    }

    @Override
    public int getMaxVolume() {
        if (this.commands.containsKey("maxVolume")) {
            return Integer.parseInt(this.commands.get("maxVolume"));
        }
        return 100;
    }

    @Override
    public int getMinRate() {
        if (this.commands.containsKey("minRate")) {
            return Integer.parseInt(this.commands.get("minRate"));
        }
        return 0;
    }

    @Override
    public int getMaxRate() {
        if (this.commands.containsKey("maxRate")) {
            return Integer.parseInt(this.commands.get("maxRate"));
        }
        return 100;
    }

    @Override
    public boolean isInterruptible() {
        return this.commands.containsKey("cmd_sayInterrupt");
    }

    @Override
    public boolean isPausable() {
        return this.commands.containsKey("cmd_pause") && this.commands.containsKey("cmd_resume");
    }

    @Override
    public boolean setPaused(boolean bl) {
        if (bl) {
            this.send(this.commands.get("cmd_pause"));
        } else {
            this.send(this.commands.get("cmd_resume"));
        }
        return true;
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        if (bl && this.commands.containsKey("cmd_sayInterrupt")) {
            this.send(this.commands.get("cmd_sayInterrupt").replace("%s", string));
        } else {
            this.send(this.commands.get("cmd_say").replace("%s", string));
        }
        return true;
    }
}

