/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.Properties;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineException;
import javax.speech.EngineModeDesc;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;
import javax.speech.synthesis.SynthesizerProperties;
import javax.speech.synthesis.Voice;
import quentinc.accessibility.Speech;

public class JavaSpeechAPI
extends Speech {
    private static final int MIN_RATE = 100;
    private static final int MAX_RATE = 270;
    private static JavaSpeechAPI obj = null;
    private Synthesizer synth = null;
    private SynthesizerProperties sp = null;
    private int curRate = -1;

    public static Speech getInstance(Properties properties) {
        if (obj != null) {
            return obj;
        }
        try {
            obj = new JavaSpeechAPI(properties);
            return obj;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public JavaSpeechAPI(Properties properties) throws AudioException, EngineException, PropertyVetoException {
        String string;
        String string2;
        int n = 65535;
        String string3 = properties.getProperty("voiceGender", "null").toLowerCase();
        if (string3.equals("male")) {
            n = 2;
        } else if (string3.equals("female")) {
            n = 1;
        } else if (string3.equals("neutral")) {
            n = 4;
        }
        int n2 = 65535;
        String string4 = properties.getProperty("voiceAge", "null").toLowerCase();
        if (string4.equals("child")) {
            n2 = 1;
        } else if (string4.equals("teenager")) {
            n2 = 2;
        } else if (string4.equals("younger adult")) {
            n2 = 4;
        } else if (string4.equals("adult") || string4.equals("middle adult")) {
            n2 = 8;
        } else if (string4.equals("older adult")) {
            n2 = 16;
        } else if (string4.equals("neutral")) {
            n2 = 32;
        }
        String string5 = properties.getProperty("voiceName", null);
        if (string5 != null && (string5.equals("") || string5.equals("null"))) {
            string5 = null;
        }
        if ((string2 = properties.getProperty("voiceStyle", null)) != null && (string2.equals("") || string2.equals("null"))) {
            string2 = null;
        }
        if ((string = properties.getProperty("engine", null)) != null && (string.equals("") || string.equals("null"))) {
            string = null;
        }
        SynthesizerModeDesc synthesizerModeDesc = new SynthesizerModeDesc(string, "general", Locale.getDefault(), null, null);
        SynthesizerModeDesc synthesizerModeDesc2 = new SynthesizerModeDesc(string, "general", Locale.US, null, null);
        Voice voice = new Voice(string5, n, n2, string2);
        Synthesizer synthesizer = Central.createSynthesizer((EngineModeDesc)synthesizerModeDesc);
        if (synthesizer == null) {
            synthesizer = Central.createSynthesizer((EngineModeDesc)synthesizerModeDesc2);
        }
        if (synthesizer == null) {
            throw new RuntimeException("Could not find synthesizer");
        }
        synthesizer.allocate();
        SynthesizerProperties synthesizerProperties = synthesizer.getSynthesizerProperties();
        synthesizerProperties.setVoice(voice);
        float f = (float)Double.parseDouble(properties.getProperty("pitch", "-1"));
        float f2 = (float)Double.parseDouble(properties.getProperty("pitchRange", "-1"));
        float f3 = (float)Double.parseDouble(properties.getProperty("rate", "-1"));
        float f4 = (float)Double.parseDouble(properties.getProperty("volume", "-1"));
        if (f > 0.0f) {
            synthesizerProperties.setPitch(f);
        }
        if (f2 > 0.0f) {
            synthesizerProperties.setPitchRange(f2);
        }
        if (f3 > 0.0f) {
            synthesizerProperties.setSpeakingRate(f3);
        }
        if (f4 > 0.0f) {
            synthesizerProperties.setVolume(f4);
        }
        synthesizer.resume();
        this.synth = synthesizer;
        this.sp = synthesizerProperties;
    }

    public boolean stopSpeech() {
        this.synth.cancelAll();
        return true;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public boolean isPausable() {
        return true;
    }

    @Override
    public boolean setPaused(boolean bl) {
        try {
            if (bl) {
                this.synth.pause();
            } else {
                this.synth.resume();
            }
        }
        catch (AudioException audioException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        if (bl) {
            this.stopSpeech();
        }
        this.synth.speakPlainText(string, null);
        return true;
    }

    @Override
    public boolean isRateAdjustable() {
        return true;
    }

    @Override
    public int getRate() {
        if (this.curRate < 0) {
            this.curRate = (int)this.sp.getSpeakingRate();
        }
        return this.curRate;
    }

    @Override
    public boolean setRate(int n) {
        try {
            this.sp.setSpeakingRate((float)n);
            this.curRate = n;
            return true;
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
    }

    @Override
    public boolean isVolumeAdjustable() {
        return true;
    }

    @Override
    public int getVolume() {
        return (int)(this.sp.getVolume() * 100.0f);
    }

    @Override
    public boolean setVolume(int n) {
        try {
            this.sp.setVolume((float)n / 100.0f);
            return true;
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
    }

    @Override
    public int getMinVolume() {
        return 0;
    }

    @Override
    public int getMaxVolume() {
        return 100;
    }

    @Override
    public int getMinRate() {
        return 100;
    }

    @Override
    public int getMaxRate() {
        return 270;
    }

    public void finalize() throws Exception {
        this.stopSpeech();
        this.synth.deallocate();
    }
}

