/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.util.Locale;
import java.util.Properties;
import quentinc.accessibility.Speech;
import speechd.ssip.SSIPClient;
import speechd.ssip.SSIPException;
import speechd.ssip.SSIPPriority;

public class SpeechDispatcher
extends Speech {
    private static SpeechDispatcher obj = null;
    private SSIPClient client = null;
    private SSIPPriority priority = SSIPPriority.MESSAGE;
    private int volume = 100;
    private int rate = 0;

    public static Speech getInstance(Properties properties) {
        if (obj == null) {
            obj = new SpeechDispatcher(properties);
        }
        return obj;
    }

    public SpeechDispatcher(Properties properties) {
        try {
            SSIPPriority sSIPPriority;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = "quentincApp";
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MIN_VALUE;
            int n4 = -1;
            if (properties != null) {
                string5 = properties.getProperty("application", "quentincApp");
                string7 = properties.getProperty("component", null);
                string6 = properties.getProperty("user", null);
                string = properties.getProperty("host", null);
                n4 = Integer.parseInt(properties.getProperty("port", "-1"));
                string8 = properties.getProperty("outputModule", null);
                string4 = properties.getProperty("language", null);
                string2 = properties.getProperty("voice", null);
                string3 = properties.getProperty("synthesisVoice", null);
                string9 = properties.getProperty("priority", null);
                n3 = Integer.parseInt(properties.getProperty("pitch", "-10000"));
                n2 = Integer.parseInt(properties.getProperty("rate", "-10000"));
                n = Integer.parseInt(properties.getProperty("volume", "-10000"));
            }
            if (string != null) {
                System.setProperty("speechd.host", string);
            }
            if (n4 > 0) {
                System.setProperty("speechd.port", String.valueOf(n4));
            }
            if ("auto".equals(string4)) {
                string4 = Locale.getDefault().getLanguage();
            }
            this.client = new SSIPClient(string5, string7, string6);
            if (string8 != null) {
                this.client.setOutputModule(string8);
            }
            if (string2 != null) {
                this.client.setVoice(string2);
            }
            if (string3 != null) {
                this.client.setSynthesisVoice(string3);
            }
            if (string4 != null) {
                this.client.setLanguage(string4);
            }
            if (n3 >= -100 && n3 <= 100) {
                this.client.setPitch(n3);
            }
            if (n2 >= -100 && n2 <= 100) {
                this.rate = n2;
                this.client.setRate(this.rate);
            }
            if (n >= -100 && n <= 100) {
                this.volume = n;
                this.client.setVolume(this.volume);
            }
            if (string9 != null && (sSIPPriority = SSIPPriority.valueOf((String)string9.trim().toUpperCase())) != null) {
                this.priority = sSIPPriority;
            }
        }
        catch (SSIPException sSIPException) {
            throw new RuntimeException(sSIPException);
        }
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (SSIPException sSIPException) {
            throw new RuntimeException(sSIPException);
        }
    }

    public void finalize() {
        this.close();
    }

    @Override
    public boolean isRateAdjustable() {
        return true;
    }

    @Override
    public boolean setRate(int n) {
        try {
            this.client.setRate(n);
            this.rate = n;
            return true;
        }
        catch (SSIPException sSIPException) {
            return false;
        }
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public boolean isVolumeAdjustable() {
        return true;
    }

    @Override
    public boolean setVolume(int n) {
        try {
            this.client.setVolume(n);
            this.volume = n;
            return true;
        }
        catch (SSIPException sSIPException) {
            return false;
        }
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public int getMinVolume() {
        return -100;
    }

    @Override
    public int getMaxVolume() {
        return 100;
    }

    @Override
    public int getMinRate() {
        return -100;
    }

    @Override
    public int getMaxRate() {
        return 100;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public boolean isPausable() {
        return true;
    }

    @Override
    public boolean setPaused(boolean bl) {
        try {
            if (bl) {
                this.client.pause();
            } else {
                this.client.resume();
            }
            return true;
        }
        catch (SSIPException sSIPException) {
            return false;
        }
    }

    public boolean stopSpeech() {
        try {
            this.client.cancel();
            this.client.stop();
            return true;
        }
        catch (SSIPException sSIPException) {
            return false;
        }
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        try {
            if (bl) {
                this.client.cancel();
            }
            this.client.say(this.priority, string);
            return true;
        }
        catch (SSIPException sSIPException) {
            return false;
        }
    }
}

