/*
 * Decompiled with CFR 0.152.
 */
package quentinc.game;

import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import quentinc.audio.Channel;
import quentinc.audio.Sample;
import quentinc.game.Board;
import quentinc.game.ExceptionNickname;
import quentinc.game.ExceptionServerFull;
import quentinc.game.ExceptionVersion;
import quentinc.game.Main;
import quentinc.game.Player;
import quentinc.game.RegisteredServer;
import quentinc.game.Server;
import quentinc.menu.InputMenuItem;

public class Game
implements Runnable {
    protected static int bestScore = 0;
    public static final String LETTERS = " ABCRWDFQ";
    public static final String hfKey = "7hi5i57h3hi9h5c0r374b13.";
    public static final String hfUrl = "http://quentinc.net/jeux/magicblocks/highscore.php?key=7hi5i57h3hi9h5c0r374b13.&name=%1&score=%2";
    public static final String hfServerRegisterUrl = "http://quentinc.net/jeux/magicblocks/servers.php?key=7hi5i57h3hi9h5c0r374b13.&action=%1&name=%2&port=%3";
    public static final String hfServerListUrl = "http://quentinc.net/jeux/magicblocks/servers.php";
    public static final int BOARD_WIDTH = 5;
    public static final int BOARD_HEIGHT = 5;
    public static final int[] SCORES = new int[]{1, 0, 0, 20, 35, 60, 100, 180, 300, 500, 800, 1500, 3000, 5000, 10000};
    public static final int[] COLORS = new int[]{3, 4, 5, 5, 6, 6, 7, 7, 8};
    public static final int[] TIMES = new int[]{300, 250, 200, 175, 150, 140, 130, 120, 110, 100, 90, 80, 70, 65, 60, 55, 50, 45, 40, 38, 36, 34, 32, 30, 28, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
    public static final int[] EXTRAPROBAS = new int[]{6, 4, 9, 6, 3, 2, 4, 4};
    static final int EXTRAPROBASUM;
    static Random rand;
    Main main;
    Thread thread;
    Channel chan;
    LinkedList<Sample> sampleList = new LinkedList();
    Server server;
    Socket sock;
    BufferedWriter bw;
    BufferedReader br;
    List<String> history = new ArrayList<String>();
    int gport = -1;
    int historyPtr = -1;
    int id = 0;
    String nick;
    boolean admin;
    boolean privateServer;
    boolean hearPlayers;
    Player me;
    Map<Integer, Player> players = new TreeMap<Integer, Player>();
    InputMenuItem chat;
    Board board = new Board(5, 5);
    boolean ingame = false;
    long startTime;
    int navX = 3;
    int navY = 5;
    int blockX = 0;
    int blockY = 4;
    int blockColor = 1;
    int playerSel = 1;
    int level = 0;
    int blockTime;
    int blockDrop;
    int changes;
    int switches;
    int adders;
    int removers;
    int bombs;
    int nukes;
    int extras;
    int quakes;
    int flips;
    boolean bomb = false;

    private Game(Main main) {
        this.main = main;
        this.chat = new InputMenuItem(this.main.rb.getString("chatinput"), "chat", null, null, null);
        this.chat.addMenuListener(this.main);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public static Game createSolo(Main main, String string) {
        Game game = new Game(main);
        game.admin = true;
        game.me = new Player(1, string);
        game.players.put(0, game.me);
        game.main.sayString(game.main.rb.getString("pressF2"));
        return game;
    }

    public static Game createServer(Main main, int n, String string, boolean bl, boolean bl2) throws IOException {
        Game game = new Game(main);
        game.gport = n;
        game.hearPlayers = bl2;
        game.privateServer = bl;
        game.nick = string;
        game.admin = true;
        game.server = new Server(n);
        if (!bl) {
            game.registerServer();
        }
        game.connect("127.0.0.1", n);
        game.main.sayString(game.main.rb.getString("pressF2"));
        return game;
    }

    public static Game createClient(Main main, String string, int n, String string2, boolean bl) throws IOException {
        Game game = new Game(main);
        game.hearPlayers = bl;
        game.nick = string2;
        game.connect(string, n);
        return game;
    }

    @Override
    public void run() {
        while (this.thread != null) {
            if (this.me != null && this.me.getState() == 1) {
                --this.blockTime;
                if (this.blockDrop > 0) {
                    --this.blockDrop;
                    if (this.blockDrop == 6) {
                        this.dropBlock();
                    } else if (this.blockDrop == 0) {
                        this.nextBlock();
                    }
                } else if (this.blockTime <= 0 && this.blockDrop <= 0) {
                    this.predropBlock();
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    public void close() {
        try {
            if (this.thread == null) {
                return;
            }
            this.thread = null;
            this.main.game = null;
            this.main.sayString(this.main.rb.getString("connectionLost"));
            System.out.println("Closing socket");
            if (this.sock != null) {
                this.sock.close();
            }
            System.out.println("Closing input stream");
            if (this.br != null) {
                this.br.close();
            }
            System.out.println("Closing output stream");
            if (this.bw != null) {
                this.bw.close();
            }
            System.out.println("Closing server");
            if (this.server != null) {
                if (!this.privateServer) {
                    this.unregisterServer();
                }
                this.server.close();
            }
            this.server = null;
            this.sock = null;
            this.br = null;
            this.bw = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection() {
        try {
            String string;
            while ((string = this.br.readLine()) != null) {
                String string2;
                if (string.startsWith("adduser")) {
                    String[] stringArray = string.split(" ");
                    int n = Integer.parseInt(stringArray[1]);
                    String string3 = stringArray[2];
                    this.playerJoin(n, string3);
                    continue;
                }
                if (string.startsWith("deluser")) {
                    int n = Integer.parseInt(string.substring(8).trim());
                    this.playerPart(n);
                    continue;
                }
                int n = string.indexOf(32);
                if (n < 0 || !(string2 = string.substring(0, n).trim()).matches("^\\d+$")) continue;
                int n2 = Integer.parseInt(string2);
                this.playerData(n2, string.substring(n + 1));
            }
            System.out.println("The server has closed the connection");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    protected void connect(String string, int n) throws IOException {
        this.sock = new Socket(string, n);
        System.out.println("Connection established");
        this.br = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
        this.bw = new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream()));
        this.bw.write("version 1.0\r\n");
        this.bw.write("name " + this.nick + "\r\n");
        this.bw.write("hello\r\n");
        this.bw.flush();
        String string2 = this.br.readLine();
        if (string2.equals("error version")) {
            throw new ExceptionVersion();
        }
        if (string2.equals("error name")) {
            throw new ExceptionNickname();
        }
        if (string2.equals("error full")) {
            throw new ExceptionServerFull();
        }
        if (!string2.matches("^id \\d+$")) {
            throw new IOException("Invalid data");
        }
        this.id = Integer.parseInt(string2.substring(3).trim());
        this.me = new Player(this.nick, this.id);
        this.players.put(this.id, this.me);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Game.this.handleConnection();
            }
        });
        thread.start();
    }

    public void playerData(int n, String string) {
        if (string.equals("ingame")) {
            this.main.sayString(this.main.rb.getString("welcomeIngame"));
        } else if (string.equals("waiting")) {
            this.main.sayString(this.main.rb.getString("welcomeWaiting"));
        } else if (string.equals("start")) {
            this.startGame();
        } else if (string.equals("drop")) {
            if (this.hearPlayers) {
                this.main.playSound("drop", 0.2f);
            }
        } else if (string.equals("dropend")) {
            if (this.hearPlayers) {
                this.main.playSound("dropend", 0.2f);
            }
        } else if (string.equals("explode")) {
            if (this.hearPlayers) {
                this.main.playSound("explode", 0.2f);
            }
        } else if (string.startsWith("addline")) {
            int n2 = Integer.parseInt(string.substring(8));
            if (this.me.getId() == n2) {
                this.doAddLine();
            } else if (this.hearPlayers) {
                this.main.playSound("addline", 0.2f);
            }
        } else if (string.startsWith("remline")) {
            int n3 = Integer.parseInt(string.substring(8));
            if (this.me.getId() == n3) {
                this.doRemoveLine();
            } else if (this.hearPlayers) {
                this.main.playSound("addline", 0.2f);
            }
        } else if (string.startsWith("nukefield")) {
            int n4 = Integer.parseInt(string.substring(10));
            if (this.me.getId() == n4) {
                this.doNukeField();
            } else if (this.hearPlayers) {
                this.main.playSound("explode", 0.2f);
            }
        } else if (string.startsWith("quake")) {
            int n5 = Integer.parseInt(string.substring(6));
            if (this.me.getId() == n5) {
                this.doQuake();
            } else if (this.hearPlayers) {
                this.main.playSound("explode", 0.2f);
            }
        } else if (string.startsWith("flip")) {
            int n6 = Integer.parseInt(string.substring(5));
            if (this.me.getId() == n6) {
                this.doFlip();
            } else if (this.hearPlayers) {
                this.main.playSound("change", 0.2f);
            }
        } else if (string.startsWith("bomb")) {
            int n7 = Integer.parseInt(string.substring(5));
            if (this.me.getId() == n7) {
                this.doBomb();
            } else if (this.hearPlayers) {
                this.main.playSound("change", 0.2f);
            }
        } else if (string.startsWith("change")) {
            int n8 = Integer.parseInt(string.substring(7));
            if (this.me.getId() == n8) {
                this.changeBlock();
            } else if (this.hearPlayers) {
                this.main.playSound("change", 0.2f);
            }
        } else if (string.startsWith("switch")) {
            String[] stringArray = string.split(" ");
            int n9 = Integer.parseInt(stringArray[1]);
            if (this.me.getId() == n9) {
                this.doSwitch(n, stringArray);
            } else if (this.hearPlayers) {
                this.main.playSound("switch", 0.2f);
            }
        } else if (string.startsWith("finish")) {
            String[] stringArray = string.split(" ");
            int n10 = Integer.parseInt(stringArray[1]);
            int n11 = Integer.parseInt(stringArray[2]);
            int n12 = Integer.parseInt(stringArray[3]);
            Player player = this.players.get(n);
            if (player != null) {
                player.updateScore(n10);
                player.updateClears(n11);
                player.updateTime(n12);
                player.setState(0);
                if (n == this.playerSel) {
                    this.playerSel = this.me.getId();
                }
            }
            if (this.hearPlayers) {
                this.main.playSound("gameOver", 0.2f);
            }
            if (this.haveAllPlayersFinished()) {
                this.ingame = false;
                this.sayStats();
            }
        } else if (string.equals("stats")) {
            this.ingame = false;
            this.sayStats();
        } else if (string.startsWith("say ")) {
            this.chatRecv(n, string.substring(4));
        }
    }

    public void playerJoin(int n, String string) {
        Player player = new Player(n, string);
        this.players.put(n, player);
        this.main.sayString(this.main.rb.getString("playerJoin").replace("%s", player.getName()), false);
        if (this.server != null && this.admin) {
            Server.Connection connection = null;
            if (this.server != null) {
                connection = this.server.getConnection(n);
            }
            if (connection != null) {
                connection.send("0 " + (this.ingame ? "ingame" : "waiting"));
            }
        }
    }

    public void playerPart(int n) {
        Player player = this.players.remove(n);
        if (player == null) {
            return;
        }
        String string = player.getName();
        this.main.sayString(this.main.rb.getString("playerPart").replace("%s", string), false);
    }

    public void chatSend() {
        if (this.sock == null) {
            return;
        }
        this.chatSend(this.chat.getValue());
        this.chat.setValue("");
        this.chat.setPosition(0);
    }

    public void chatSend(String string) {
        this.chatRecv(this.id, string);
        this.historyPtr = -1;
        this.send("say " + string);
    }

    public void send(String string) {
        if (this.bw == null || this.sock == null) {
            return;
        }
        try {
            this.bw.write(string + "\r\n");
            this.bw.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close();
        }
    }

    public void chatRecv(int n, String string) {
        String string2 = this.players.get(n).getName();
        String string3 = this.main.rb.getString("say1").replace("%1", string2).replace("%2", string);
        this.main.sayString(string3, false);
        this.history.add(string3);
    }

    public void startGame() {
        this.startTime = System.currentTimeMillis();
        this.level = 0;
        this.me.reset();
        for (Player player : this.players.values()) {
            player.reset();
        }
        this.board.clear();
        this.me.setState(1);
        for (Player player : this.players.values()) {
            player.setState(1);
        }
        this.flips = 0;
        this.quakes = 0;
        this.removers = 0;
        this.adders = 0;
        this.nukes = 0;
        this.bombs = 0;
        this.switches = 0;
        this.changes = 0;
        this.extras = 0;
        this.main.sayString(this.main.rb.getString("gamestarted"));
        this.main.sayString(this.main.rb.getString("level").replace("%d", String.valueOf(this.level + 1)), false);
        this.ingame = true;
        this.blockX = 0;
        this.navX = 0;
        this.blockY = 4;
        this.navY = 4;
        this.blockTime = -1;
        this.blockDrop = 4;
        this.bomb = false;
    }

    public Player getNthPlayer(int n) {
        if (n >= this.players.size()) {
            return null;
        }
        Player player = null;
        Iterator<Player> iterator = this.players.values().iterator();
        for (int i = 0; i <= n; ++i) {
            player = iterator.next();
        }
        return player;
    }

    public void sayPlayer(int n) {
        Player player = this.getNthPlayer(n);
        if (player == null) {
            this.main.sayString(this.main.rb.getString("noplayerthere"));
        } else {
            this.main.sayString(this.main.rb.getString("state" + player.getState()).replace("%s", player.getName()));
        }
    }

    public void selectPlayer(int n) {
        Player player = this.getNthPlayer(n);
        if (player == null || player.getState() != 1) {
            return;
        }
        this.playerSel = player.getId();
        this.main.sayString(this.main.rb.getString("playerselected").replace("%s", player.getName()));
    }

    public void sayCurCell() {
        int n = this.board.get(this.navX, this.navY) & 0xFF;
        String string = String.format("%c%d", Character.valueOf((char)(this.navX + 65)), 5 - this.navY);
        this.main.sayString(string);
        if (n > 0) {
            this.main.playSound(String.valueOf(n));
        }
    }

    public void sendAddLine() {
        if (this.adders <= 0) {
            return;
        }
        --this.adders;
        if (this.playerSel == this.me.getId()) {
            this.doAddLine();
        }
        this.send("addline " + this.playerSel);
    }

    public void sendRemoveLine() {
        if (this.removers <= 0) {
            return;
        }
        --this.removers;
        if (this.playerSel == this.me.getId()) {
            this.doRemoveLine();
        }
        this.send("remline " + this.playerSel);
    }

    public void sendNukeField() {
        if (this.nukes <= 0) {
            return;
        }
        --this.nukes;
        if (this.playerSel == this.me.getId()) {
            this.doNukeField();
        }
        this.send("nukefield " + this.playerSel);
    }

    public void sendQuake() {
        if (this.quakes <= 0) {
            return;
        }
        --this.quakes;
        if (this.playerSel == this.me.getId()) {
            this.doQuake();
        }
        this.send("quake " + this.playerSel);
    }

    public void sendFlip() {
        if (this.flips <= 0) {
            return;
        }
        --this.flips;
        if (this.playerSel == this.me.getId()) {
            this.doFlip();
        }
        this.send("flip " + this.playerSel);
    }

    public void sendBomb() {
        if (this.bombs <= 0) {
            return;
        }
        --this.bombs;
        if (this.playerSel == this.me.getId()) {
            this.doBomb();
        }
        this.send("bomb " + this.playerSel);
    }

    public void sendSwitch(int n, boolean bl) {
        if (this.switches <= 0) {
            return;
        }
        --this.switches;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("switch ").append(n).append(" ").append(bl ? "true" : "false").append(" ");
        for (int i = 0; i < 25; ++i) {
            int n2 = i % 5;
            int n3 = i / 5;
            stringBuilder.append(this.board.get(n2, n3)).append(" ");
        }
        this.send(stringBuilder.toString());
    }

    public void doSwitch(int n, String[] stringArray) {
        boolean bl = stringArray[2].equals("true");
        if (bl) {
            this.sendSwitch(n, false);
        }
        for (int i = 0; i < 25; ++i) {
            int n2 = i % 5;
            int n3 = i / 5;
            int n4 = Integer.parseInt(stringArray[i + 3]);
            this.board.set(n2, n3, n4);
        }
        this.main.playSound("switch");
    }

    public void doAddLine() {
        int n;
        this.main.playSound("addline");
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j == 0 && this.board.get(i, j) != 0) {
                    this.gameOver();
                    return;
                }
                this.board.set(i, j, this.board.get(i, j + 1));
            }
        }
        ArrayList arrayList = new ArrayList(8);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(8);
        int n2 = COLORS[Math.min(COLORS.length - 1, this.level)];
        for (n = 1; n <= n2; ++n) {
            arrayList2.add(n);
        }
        n = 4;
        for (int i = 0; i < 5; ++i) {
            arrayList.clear();
            arrayList.addAll(arrayList2);
            if (i > 0) {
                arrayList.remove((Object)(this.board.get(i - 1, n) & 0xFF));
            }
            arrayList.remove((Object)(this.board.get(i, n - 1) & 0xFF));
            int n3 = (Integer)arrayList.get(rand.nextInt(arrayList.size()));
            this.board.set(i, n, n3);
        }
    }

    public void doRemoveLine() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 4; j > 0; --j) {
                this.board.set(i, j, this.board.get(i, j - 1));
            }
            this.board.set(i, 0, 0);
        }
        this.main.playSound("addline");
    }

    public void doBomb() {
        this.main.playSound("change");
        this.bomb = true;
    }

    public void doNukeField() {
        this.main.playSound("explode");
        this.board.clear();
    }

    public void doFlip() {
        this.main.playSound("change");
        int n = COLORS[Math.min(this.level, COLORS.length - 1)];
        int n2 = rand.nextInt(n - 1);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                int n3 = this.board.get(i, j);
                if (n3 == 0) continue;
                n3 = 1 + (n3 - 1 + n2) % n;
                this.board.set(i, j, n3);
            }
        }
    }

    public void doQuake() {
        this.main.playSound("explode");
        for (int i = 0; i < 5; ++i) {
            int n;
            int n2 = rand.nextInt(4);
            int[] nArray = new int[5];
            for (n = 0; n < 5; ++n) {
                nArray[n] = this.board.get(n, i);
            }
            for (n = 0; n < 5; ++n) {
                this.board.set(n, i, nArray[(n + n2) % 5]);
            }
        }
    }

    public void sendChangeBlock() {
        if (this.playerSel == this.me.getId()) {
            this.changeBlock();
        }
        this.send("change " + this.playerSel);
    }

    public void changeBlock() {
        if (this.changes <= 0) {
            return;
        }
        --this.changes;
        this.main.playSound("change");
        this.blockTime = -1;
        this.blockDrop = 2;
    }

    public void updateCurBlock() {
        this.blockY = this.board.getTopMostFreeRow(this.blockX);
    }

    public void sayCurBlock() {
        this.main.playSound(String.valueOf(this.blockColor & 0xFF));
    }

    public void predropBlock() {
        if (this.blockDrop > 0) {
            return;
        }
        this.updateCurBlock();
        if (this.blockY < 0) {
            this.gameOver();
            return;
        }
        this.blockDrop = 7 + this.blockY;
        this.main.playSound("drop");
        this.send("drop");
    }

    public void dropBlock() {
        if (this.bomb) {
            this.bomb = false;
            for (int i = this.blockX - 1; i <= this.blockX + 1; ++i) {
                if (i < 0 || i >= 5) continue;
                for (int j = this.blockY - 1; j <= this.blockY + 1; ++j) {
                    if (j < 0 || j >= 5) continue;
                    this.board.set(i, j, 0);
                }
            }
            this.main.playSound("explode");
            this.send("explode");
            return;
        }
        this.board.set(this.blockX, this.blockY, this.blockColor);
        int n = 0;
        int n2 = 0;
        while ((n = this.board.check()) > 0) {
            n2 += n & 0xFF;
        }
        if (n2 > 0) {
            this.me.updateClears(n2);
            this.me.updateScore(SCORES[Math.min(n2, SCORES.length - 1)] * (this.level + 2));
            int n3 = this.me.getClears() / 15;
            if (this.level < n3) {
                this.level = n3;
                this.main.sayString(this.main.rb.getString("level").replace("%d", String.valueOf(this.level + 1)));
            }
            this.addBonus();
            this.main.playSound("explode");
            this.send("explode");
        } else {
            this.me.updateScore(SCORES[0] * (this.level + 2) * Math.max(1, this.blockTime / 100));
            this.main.playSound("dropend");
            this.send("dropend");
        }
    }

    public void addBonus() {
        if (this.sock != null && rand.nextInt(3) == 1) {
            int n = 0;
            for (int i = rand.nextInt(EXTRAPROBASUM); i >= EXTRAPROBAS[n]; i -= EXTRAPROBAS[n++]) {
            }
            this.addSingleBonus(++n);
            this.main.sayString("" + LETTERS.charAt(n));
            this.main.playSound("bonus", 0.6f);
        }
    }

    public void addSingleBonus(int n) {
        switch (n) {
            case 1: {
                ++this.adders;
                break;
            }
            case 2: {
                ++this.bombs;
                break;
            }
            case 3: {
                ++this.changes;
                break;
            }
            case 4: {
                ++this.removers;
                break;
            }
            case 5: {
                ++this.switches;
                break;
            }
            case 6: {
                ++this.nukes;
                break;
            }
            case 7: {
                ++this.flips;
                break;
            }
            case 8: {
                ++this.quakes;
            }
        }
    }

    public void nextBlock() {
        int n = COLORS[Math.min(this.level, COLORS.length - 1)];
        this.blockColor = 1 + rand.nextInt(n);
        this.blockTime = TIMES[Math.min(this.level, TIMES.length - 1)];
        this.updateCurBlock();
        this.sayCurBlock();
    }

    public void gameOver() {
        if (this.me != null) {
            int n = (int)((System.currentTimeMillis() - this.startTime) / 1000L);
            this.me.updateTime(n);
            this.me.setState(0);
            this.send("finished " + this.me.getScore() + " " + this.me.getClears() + " " + this.me.getTime());
        }
        this.main.playSound("gameOver");
        this.main.sayString(this.main.rb.getString("gameOver"));
        if (this.haveAllPlayersFinished()) {
            this.ingame = false;
            this.sayStats();
            this.send("stats");
        } else {
            this.main.sayString(this.main.rb.getString("waitingForFinish"), false);
        }
    }

    public boolean haveAllPlayersFinished() {
        if (this.sock == null) {
            return true;
        }
        boolean bl = true;
        for (Player player : this.players.values()) {
            if (bl = bl && player.getState() == 0) continue;
            break;
        }
        return bl;
    }

    public void sayStats() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.main.rb.getString("statH")).append("\r\n");
        if (this.sock == null) {
            stringBuilder.append(String.format(this.main.rb.getString("stat2"), this.me.getScore(), this.me.getClears(), this.me.getTime() / 60, this.me.getTime() % 60)).append("\r\n");
            int n = this.me.getScore();
            if (n > bestScore) {
                stringBuilder.append(this.main.rb.getString("beatPersonalScore").replace("%1", String.valueOf(n)).replace("%2", String.valueOf(bestScore))).append("\r\n");
                bestScore = n;
            } else {
                stringBuilder.append(this.main.rb.getString("yourPersonalScore").replace("%2", String.valueOf(bestScore))).append("\r\n");
            }
        } else {
            for (Player object : this.players.values()) {
                stringBuilder.append(String.format(this.main.rb.getString("stat1"), object.getName(), object.getScore(), object.getClears(), object.getTime() / 60, object.getTime() % 60)).append("\r\n");
            }
        }
        String string = stringBuilder.toString();
        this.history.add(string);
        this.historyPtr = -1;
        this.main.sayString(string, false);
        if (this.sock == null) {
            try {
                stringBuilder = new StringBuilder();
                String iOException = hfUrl.replace("%1", this.me.getName()).replace("%2", String.valueOf(this.me.getScore()));
                URL uRL = new URL(iOException);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                int n = Integer.parseInt(bufferedReader.readLine());
                if (n >= 1 && n <= 30) {
                    stringBuilder.append(this.main.rb.getString("winTop30").replace("%d", String.valueOf(n))).append(".\r\n");
                }
                stringBuilder.append(this.main.rb.getString("top30")).append(".\r\n");
                for (int i = 0; i < 30; ++i) {
                    String[] stringArray = bufferedReader.readLine().split(":");
                    stringBuilder.append(i + 1).append(". ").append(stringArray[0]).append(" : ").append(stringArray[1]).append(".\r\n");
                }
                bufferedReader.close();
                string = stringBuilder.toString();
                this.history.add(string);
                this.historyPtr = -1;
                this.main.sayString(string, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.me.getState() == 0) {
            this.chat.keyTyped(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.me.getState() == 0) {
            this.chat.keyReleased(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 33) {
            --this.historyPtr;
            if (this.historyPtr < 0) {
                this.historyPtr = this.history.size() - 1;
            }
            if (this.historyPtr >= 0) {
                this.main.sayString(this.history.get(this.historyPtr));
            }
            return;
        }
        if (n == 34) {
            if (this.historyPtr < 0) {
                this.historyPtr = this.history.size() - 1;
            }
            ++this.historyPtr;
            if (this.historyPtr >= this.history.size()) {
                this.historyPtr = this.history.size() - 1;
            }
            this.main.sayString(this.history.get(this.historyPtr));
            return;
        }
        if (n == 27) {
            this.close();
            this.main.game = null;
            this.main.createNet.setExpanded(false);
            this.main.joinNet.setExpanded(false);
            this.main.newGame.setExpanded(false);
        } else if (keyEvent.getModifiers() == 2 && n >= 48 && n <= 57) {
            n = (n - 49 + 10) % 10;
            this.sayPlayer(n);
            return;
        }
        if (this.me.getState() == 0) {
            if (this.admin && !this.ingame && n == 113) {
                this.send("start");
                this.startGame();
            }
            if (!keyEvent.isConsumed()) {
                this.chat.keyPressed(keyEvent);
            }
        } else {
            switch (n) {
                case 79: 
                case 101: {
                    this.sayCurCell();
                    break;
                }
                case 37: 
                case 74: 
                case 100: {
                    this.navX = this.blockX = Math.max(this.blockX - 1, 0);
                    this.updateCurBlock();
                    this.sayCurCell();
                    break;
                }
                case 39: 
                case 76: 
                case 102: {
                    this.navX = this.blockX = Math.min(this.blockX + 1, 4);
                    this.updateCurBlock();
                    this.sayCurCell();
                    break;
                }
                case 10: 
                case 32: 
                case 96: {
                    this.predropBlock();
                    break;
                }
                case 40: 
                case 75: 
                case 98: {
                    this.navY = Math.min(this.navY + 1, 4);
                    this.sayCurCell();
                    break;
                }
                case 38: 
                case 73: 
                case 104: {
                    this.navY = Math.max(this.navY - 1, 0);
                    this.sayCurCell();
                    break;
                }
                case 8: 
                case 9: 
                case 85: 
                case 103: {
                    this.updateCurBlock();
                    this.sayCurBlock();
                    break;
                }
                case 83: {
                    this.main.sayString(String.valueOf(this.me.getScore()));
                    break;
                }
                case 69: {
                    this.main.sayString(String.valueOf(this.level + 1));
                    break;
                }
                case 90: {
                    this.main.sayString(String.valueOf(this.me.getClears()));
                    break;
                }
                case 65: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.adders));
                        break;
                    }
                    this.sendAddLine();
                    break;
                }
                case 66: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.bombs));
                        break;
                    }
                    this.sendBomb();
                    break;
                }
                case 67: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.changes));
                        break;
                    }
                    this.sendChangeBlock();
                    break;
                }
                case 68: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.nukes));
                        break;
                    }
                    this.sendNukeField();
                    break;
                }
                case 82: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.removers));
                        break;
                    }
                    this.sendRemoveLine();
                    break;
                }
                case 87: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.switches));
                        break;
                    }
                    this.sendSwitch(this.playerSel, true);
                    break;
                }
                case 81: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.quakes));
                        break;
                    }
                    this.sendQuake();
                    break;
                }
                case 70: {
                    if (keyEvent.getModifiers() == 2) {
                        this.main.sayString(String.valueOf(this.flips));
                        break;
                    }
                    this.sendFlip();
                }
            }
            if (n >= 48 && n <= 57) {
                n = (n - 49 + 10) % 10;
                if (keyEvent.getModifiers() == 2) {
                    this.sayPlayer(n);
                } else {
                    this.selectPlayer(n);
                }
            }
        }
    }

    private void registerServer() {
        try {
            String string = hfServerRegisterUrl.replace("%1", "register").replace("%2", this.nick).replace("%3", String.valueOf(this.gport));
            URL uRL = new URL(string);
            uRL.openStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void unregisterServer() {
        try {
            String string = hfServerRegisterUrl.replace("%1", "unregister").replace("%2", this.nick).replace("%3", String.valueOf(this.gport));
            URL uRL = new URL(string);
            uRL.openStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Collection<RegisteredServer> getServerList() {
        LinkedList<RegisteredServer> linkedList = new LinkedList<RegisteredServer>();
        try {
            URL uRL = new URL(hfServerListUrl);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "iso-8859-1"));
            int n = Integer.parseInt(bufferedReader.readLine().trim());
            for (int i = 0; i < n; ++i) {
                String[] stringArray = bufferedReader.readLine().trim().split(",");
                String string = stringArray[0];
                String string2 = stringArray[1];
                int n2 = Integer.parseInt(stringArray[2]);
                int n3 = Integer.parseInt(stringArray[3]);
                linkedList.add(new RegisteredServer(string, string2, n2, n3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }

    static {
        rand = new Random();
        int n = 0;
        for (int i = 0; i < EXTRAPROBAS.length; ++i) {
            n += EXTRAPROBAS[i];
        }
        EXTRAPROBASUM = n;
    }
}

