/*
 * Decompiled with CFR 0.152.
 */
package quentinc.game;

import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import quentinc.accessibility.Speech;
import quentinc.audio.AudioManager;
import quentinc.audio.Channel;
import quentinc.audio.ChannelGroup;
import quentinc.audio.Sample;
import quentinc.audio.StreamedSample;
import quentinc.game.ExceptionNickname;
import quentinc.game.ExceptionServerFull;
import quentinc.game.ExceptionVersion;
import quentinc.game.Game;
import quentinc.game.RegisteredServer;
import quentinc.menu.AbstractMenuItem;
import quentinc.menu.InputMenuItem;
import quentinc.menu.Menu;
import quentinc.menu.MenuItem;
import quentinc.menu.MenuListener;
import quentinc.menu.ToggleMenuItem;

public class Main
extends WindowAdapter
implements KeyListener,
MenuListener {
    static Speech speech = null;
    static String currentIp = null;
    static File appdir = null;
    Frame win;
    ResourceBundle rb;
    ResourceBundle rb2;
    ChannelGroup music;
    ChannelGroup fx;
    Channel musicChan;
    Menu menu;
    Menu createNet;
    Menu joinNet;
    Menu newGame;
    Menu enterIp;
    Menu selectList;
    MenuItem back;
    InputMenuItem ip1;
    InputMenuItem port1;
    InputMenuItem pseudo1;
    InputMenuItem ip2;
    InputMenuItem port2;
    InputMenuItem pseudo2;
    InputMenuItem pseudo3;
    ToggleMenuItem privateServer;
    ToggleMenuItem listen1;
    ToggleMenuItem listen2;
    Game game = null;
    Map<String, Sample> samples = new HashMap<String, Sample>();
    StreamedSample musicSmp;
    String nick;
    int port;
    int bufsize = 64;
    int sampleRate = 44100;
    String language = "auto";

    public static void main(String[] stringArray) throws Exception {
        new Main();
    }

    public File getApplicationRootPath() {
        String string = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        string = string.substring(0, 1 + string.lastIndexOf(47));
        if (System.getProperty("os.name").toLowerCase().trim().contains("windows")) {
            string = string.substring(1).replace('/', '\\');
        }
        return new File(string);
    }

    public Main() throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        appdir = this.getApplicationRootPath();
        PrintStream printStream = new PrintStream(new FileOutputStream(new File(appdir, "stdout.txt")));
        System.setOut(printStream);
        System.setErr(printStream);
        String string = "127.0.0.1";
        int n = 100;
        int n2 = 75;
        int n3 = -1;
        int n4 = 2;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        try {
            serializable = new Properties();
            object2 = new BufferedReader(new FileReader(new File(appdir, "config.ini")));
            ((Properties)serializable).load((Reader)object2);
            ((BufferedReader)object2).close();
            this.nick = ((Properties)serializable).getProperty("nick", this.nick);
            this.port = Integer.parseInt(((Properties)serializable).getProperty("port", "11088"));
            string = ((Properties)serializable).getProperty("server", string);
            this.bufsize = Integer.parseInt(((Properties)serializable).getProperty("audioBufferMs", String.valueOf(this.bufsize)));
            this.sampleRate = Integer.parseInt(((Properties)serializable).getProperty("audioSampleRate", String.valueOf(this.sampleRate)));
            n = Integer.parseInt(((Properties)serializable).getProperty("soundVolume", String.valueOf(n)));
            n2 = Integer.parseInt(((Properties)serializable).getProperty("musicVolume", String.valueOf(n2)));
            bl = ((Properties)serializable).getProperty("musicOn", "true").equalsIgnoreCase("true");
            bl3 = ((Properties)serializable).getProperty("hearOtherPlayers", "true").equalsIgnoreCase("true");
            bl2 = ((Properties)serializable).getProperty("privateServer", "false").equalsIgnoreCase("true");
            n3 = Integer.parseInt(((Properties)serializable).getProperty("voiceVolume", String.valueOf(n3)));
            n4 = Integer.parseInt(((Properties)serializable).getProperty("voiceRate", String.valueOf(n4)));
            this.language = ((Properties)serializable).getProperty("language", this.language);
            Game.bestScore = Integer.parseInt(((Properties)serializable).getProperty("personalRecord", String.valueOf(Game.bestScore)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.language.equalsIgnoreCase("auto")) {
            Locale.setDefault(new Locale(this.language));
        }
        this.rb = ResourceBundle.getBundle("lang");
        this.rb2 = ResourceBundle.getBundle("menuinterf");
        serializable = new File(appdir, "ttscfg.properties");
        object2 = null;
        if (((File)serializable).exists()) {
            try {
                object = new BufferedReader(new FileReader((File)serializable));
                object2 = new Properties();
                ((Properties)object2).load((Reader)object);
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        speech = Speech.getInstance((Properties)object2);
        if (n3 < 0) {
            n3 = speech.getMaxVolume();
        }
        speech.setVolume(n3);
        if (n4 <= -100) {
            n4 = 0;
        }
        speech.setRate(n4);
        object = AudioManager.getInstance();
        ((AudioManager)object).open(this.sampleRate, 2, (float)this.bufsize / 1000.0f);
        ((AudioManager)object).start();
        this.music = ((AudioManager)object).createSubGroup(1);
        this.fx = ((AudioManager)object).createSubGroup(32);
        this.fx.setVolume((float)n / 100.0f);
        this.music.setVolume((float)n2 / 100.0f);
        Menu.setStrings(this.rb2);
        this.menu = this.createMenu("mainmenu");
        this.newGame = this.createMenu("newGame");
        this.createNet = this.createMenu("createNet");
        this.joinNet = this.createMenu("joinNet");
        this.enterIp = this.createMenu("joinGameDirectEnterIp");
        this.selectList = this.createMenu("joinGameSelectInList");
        this.ip1 = this.createInputMenuItem("ipaddr", "joinGame");
        this.port1 = this.createInputMenuItem("port", "joinGAme");
        this.pseudo1 = this.createInputMenuItem("pseudo", "joinGame");
        this.ip2 = this.createInputMenuItem("ipaddr2", "createGame");
        this.port2 = this.createInputMenuItem("port", "createGame");
        this.pseudo2 = this.createInputMenuItem("pseudo", "createGame");
        this.pseudo3 = this.createInputMenuItem("pseudo", "newGame");
        this.back = this.createMenuItem("goBack", "goBack");
        this.privateServer = this.createToggleMenuItem("togglePrivateServer", "createGame", bl2);
        this.listen1 = this.createToggleMenuItem("toggleHearPlayers", "", !bl3);
        this.listen2 = this.createToggleMenuItem("toggleHearPlayers", "createGame", !bl3);
        this.createNet.add(this.ip2);
        this.createNet.add(this.port2);
        this.createNet.add(this.pseudo2);
        this.createNet.add(this.privateServer);
        this.createNet.add(this.listen2);
        this.createNet.add(this.createMenuItem("createnow", "createGame"));
        this.createNet.add(this.back);
        this.enterIp.add(this.ip1);
        this.enterIp.add(this.port1);
        this.joinNet.add(this.pseudo1);
        this.joinNet.add(this.listen1);
        this.enterIp.add(this.createMenuItem("joinnow", "joinGame"));
        this.enterIp.add(this.back);
        this.joinNet.add(this.selectList);
        this.joinNet.add(this.enterIp);
        this.joinNet.add(this.back);
        this.newGame.add(this.pseudo3);
        this.newGame.add(this.createMenuItem("newGame", "newGame"));
        this.newGame.add(this.back);
        this.menu.add(this.newGame);
        this.menu.add(this.joinNet);
        this.menu.add(this.createNet);
        this.menu.add(this.createMenuItem("exit", "exit"));
        this.menu.setExpanded(true);
        if (this.nick == null) {
            this.nick = this.rb.getString("defNick");
        }
        if (this.port < 1024) {
            this.port = 11088;
        }
        this.ip1.setValue(string);
        this.ip2.setValue(string);
        this.pseudo1.setValue(this.nick);
        this.pseudo2.setValue(this.nick);
        this.pseudo3.setValue(this.nick);
        this.port1.setValue(String.valueOf(this.port));
        this.port2.setValue(String.valueOf(this.port));
        for (int i = 1; i <= 9; ++i) {
            this.getSample(String.valueOf(i));
        }
        this.getSample("drop");
        this.getSample("dropend");
        this.getSample("switch");
        this.getSample("addline");
        this.getSample("move");
        this.getSample("explode");
        this.getSample("bonus");
        this.getSample("gameOver");
        this.getSample("change");
        if (bl) {
            this.startMusic();
        }
        this.win = new Frame("QuentinC Magic Blocks v1.1");
        this.win.addWindowListener(this);
        this.win.addKeyListener(this);
        Set set = Collections.emptySet();
        this.win.setFocusTraversalKeys(0, set);
        this.win.setFocusTraversalKeys(1, set);
        this.win.pack();
        this.win.setVisible(true);
        this.sayString(this.rb.getString("welcome"));
    }

    private InputMenuItem createInputMenuItem(String string, String string2) {
        InputMenuItem inputMenuItem = new InputMenuItem(this.rb.getString(string), string2, null);
        inputMenuItem.addMenuListener(this);
        return inputMenuItem;
    }

    private ToggleMenuItem createToggleMenuItem(String string, String string2, boolean bl) {
        ToggleMenuItem toggleMenuItem = new ToggleMenuItem(this.rb.getString(string), string2, bl);
        toggleMenuItem.addMenuListener(this);
        return toggleMenuItem;
    }

    private MenuItem createMenuItem(String string, String string2) {
        MenuItem menuItem = new MenuItem(this.rb.getString(string), string2);
        menuItem.addMenuListener(this);
        return menuItem;
    }

    private Menu createMenu(String string) {
        Menu menu = new Menu(this.rb.getString(string));
        menu.addMenuListener(this);
        return menu;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Closing game");
        if (this.game != null) {
            this.game.close();
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("personalRecord", String.valueOf(Game.bestScore));
            properties.setProperty("hearOtherPlayers", !this.listen1.getState() ? "true" : "false");
            properties.setProperty("privateServer", this.privateServer.getState() ? "true" : "false");
            properties.setProperty("language", this.language);
            properties.setProperty("server", this.ip1.getValue());
            properties.setProperty("port", String.valueOf(this.port));
            properties.setProperty("nick", this.nick);
            properties.setProperty("audioBufferMs", String.valueOf(this.bufsize));
            properties.setProperty("soundVolume", String.valueOf((int)(this.fx.getVolume() * 100.0f)));
            properties.setProperty("musicVolume", String.valueOf((int)(this.music.getVolume() * 100.0f)));
            properties.setProperty("musicOn", this.musicChan != null ? "true" : "false");
            properties.setProperty("voiceVolume", String.valueOf(speech.getVolume()));
            properties.setProperty("voiceRate", String.valueOf(speech.getRate()));
            properties.setProperty("audioSampleRate", String.valueOf(this.sampleRate));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(appdir, "config.ini")));
            properties.store(bufferedWriter, "Settings");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    public void startMusic() {
        try {
            this.musicSmp = StreamedSample.load(this.getClass().getResource("/music.ogg"));
            this.musicChan = this.music.loop(this.musicSmp);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.game == null) {
            this.menu.keyPressed(keyEvent);
        } else {
            this.game.keyPressed(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (this.game == null && n == 113) {
            this.menuClicked("newGame");
        } else if (n == 116) {
            this.fx.setVolume(Math.max(0.0f, this.fx.getVolume() - 0.05f));
            this.playSound("move");
        } else if (n == 117) {
            this.fx.setVolume(Math.min(1.0f, this.fx.getVolume() + 0.05f));
            this.playSound("move");
        } else if (n == 118) {
            if (n2 == 1 && this.musicChan != null) {
                this.musicChan.setPitch(Math.max(0.5f, this.musicChan.getPitch() - 0.05f));
            } else {
                this.music.setVolume(Math.max(0.0f, this.music.getVolume() - 0.05f));
            }
        } else if (n == 119) {
            if (n2 == 1 && this.musicChan != null) {
                this.musicChan.setPitch(Math.min(2.0f, this.musicChan.getPitch() + 0.05f));
            } else {
                this.music.setVolume(Math.min(1.0f, this.music.getVolume() + 0.05f));
            }
        } else if (n == 120) {
            this.playSound("move");
            if (this.musicChan == null) {
                this.startMusic();
            } else {
                this.musicChan.stop();
                this.musicChan = null;
            }
        } else if (n == 123) {
            if (n2 == 1 && speech.isRateAdjustable()) {
                int n3 = Math.max(1, (speech.getMaxRate() - speech.getMinRate()) / 20);
                speech.setRate(Math.max(speech.getMinRate(), Math.min(speech.getMaxRate(), speech.getRate() + n3)));
                int n4 = (int)Math.round(100.0 * (double)(speech.getRate() - speech.getMinRate()) / (double)(speech.getMaxRate() - speech.getMinRate()));
                this.sayString(n4 + "%");
            } else if (n2 == 0 && speech.isVolumeAdjustable()) {
                speech.setVolume(Math.min(speech.getMaxVolume(), Math.max(speech.getMinVolume(), speech.getVolume() + Math.max(1, (speech.getMaxVolume() - speech.getMinVolume()) / 20))));
                int n5 = (int)Math.round(100.0 * (double)(speech.getVolume() - speech.getMinVolume()) / (double)(speech.getMaxVolume() - speech.getMinVolume()));
                this.sayString(n5 + "%");
            }
        } else if (n == 122) {
            if (n2 == 1 && speech.isRateAdjustable()) {
                int n6 = -Math.max(1, (speech.getMaxRate() - speech.getMinRate()) / 20);
                speech.setRate(Math.max(speech.getMinRate(), Math.min(speech.getMaxRate(), speech.getRate() + n6)));
                int n7 = (int)Math.round(100.0 * (double)(speech.getRate() - speech.getMinRate()) / (double)(speech.getMaxRate() - speech.getMinRate()));
                this.sayString(n7 + "%");
            } else if (n2 == 0 && speech.isVolumeAdjustable()) {
                speech.setVolume(Math.min(speech.getMaxVolume(), Math.max(speech.getMinVolume(), speech.getVolume() - Math.max(1, (speech.getMaxVolume() - speech.getMinVolume()) / 20))));
                int n8 = (int)Math.round(100.0 * (double)(speech.getVolume() - speech.getMinVolume()) / (double)(speech.getMaxVolume() - speech.getMinVolume()));
                this.sayString(n8 + "%");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.game == null) {
            this.menu.keyReleased(keyEvent);
        } else {
            this.game.keyReleased(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.game == null) {
            this.menu.keyTyped(keyEvent);
        } else {
            this.game.keyTyped(keyEvent);
        }
    }

    @Override
    public void menuClicked(AbstractMenuItem abstractMenuItem) {
        String string = abstractMenuItem.getActionCommand();
        this.menuClicked(string);
    }

    public void menuClicked(String string) {
        this.playSound("move");
        if (string.equals("exit")) {
            this.windowClosing(null);
        } else if (string.equals("newGame")) {
            this.nick = this.pseudo3.getValue();
            this.pseudo2.setValue(this.nick);
            this.pseudo1.setValue(this.nick);
            this.game = Game.createSolo(this, this.nick);
        } else if (string.startsWith("joinDef")) {
            String[] stringArray = string.split(" ");
            this.ip1.setValue(stringArray[1]);
            this.port1.setValue(stringArray[2]);
            this.menuClicked("joinGame");
        } else if (string.equals("joinGame")) {
            try {
                this.port = Integer.parseInt(this.port1.getValue());
                this.nick = this.pseudo1.getValue();
                this.game = Game.createClient(this, this.ip1.getValue(), this.port, this.nick, !this.listen2.getState());
                this.listen1.setState(this.listen2.getState());
                this.pseudo2.setValue(this.nick);
                this.pseudo3.setValue(this.nick);
                this.port2.setValue(String.valueOf(this.port));
            }
            catch (ExceptionVersion exceptionVersion) {
                this.sayString(this.rb.getString("errorVersion"));
            }
            catch (ExceptionNickname exceptionNickname) {
                this.sayString(this.rb.getString("errorNickname"));
            }
            catch (ExceptionServerFull exceptionServerFull) {
                this.sayString(this.rb.getString("errorServerFull"));
            }
            catch (IOException iOException) {
                this.sayString(this.rb.getString("errorConnection"));
            }
        } else if (string.equals("createGame")) {
            try {
                this.port = Integer.parseInt(this.port2.getValue());
                this.nick = this.pseudo2.getValue();
                this.game = Game.createServer(this, this.port, this.nick, this.privateServer.getState(), !this.listen1.getState());
                this.listen2.setState(this.listen1.getState());
                this.pseudo1.setValue(this.nick);
                this.pseudo3.setValue(this.nick);
                this.port1.setValue(String.valueOf(this.port));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.sayString(this.rb.getString("errorCreatingServer"));
            }
        } else if (string.equals("goBack")) {
            if (this.enterIp.isExpanded()) {
                this.enterIp.setExpanded(false);
            } else if (this.selectList.isExpanded()) {
                this.selectList.setExpanded(false);
            } else {
                this.joinNet.setExpanded(false);
                this.createNet.setExpanded(false);
            }
            this.menuSelectionChanged(this.menu, -1);
        } else if (string.equals("chat") && this.game != null) {
            this.game.chatSend();
        }
    }

    public void playSound(String string) {
        Sample sample = this.getSample(string);
        if (sample != null) {
            this.fx.play(sample);
        }
    }

    public void playSound(String string, float f) {
        Sample sample = this.getSample(string);
        if (sample != null) {
            this.fx.play(sample).setVolume(f);
        }
    }

    public Sample getSample(String string) {
        if (this.samples.containsKey(string)) {
            return this.samples.get(string);
        }
        try {
            System.out.printf("Loading %s.ogg... ", string);
            URL uRL = this.getClass().getResource("/" + string + ".ogg");
            if (uRL == null) {
                System.out.println("failed (not found)");
                return null;
            }
            Sample sample = Sample.load(uRL);
            if (sample != null) {
                this.samples.put(string, sample);
                System.out.println("OK");
            } else {
                System.out.println("failed (format)");
            }
            return sample;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void sayString(String string, boolean bl) {
        if (speech == null) {
            speech = Speech.getInstance();
        }
        speech.sayString(string, bl);
    }

    public void sayString(String string) {
        this.sayString(string, true);
    }

    @Override
    public void menuChanged(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getShortString());
    }

    @Override
    public void menuSelectionChanged(AbstractMenuItem abstractMenuItem, int n) {
        if ((Menu)abstractMenuItem == this.selectList && n == 1) {
            this.selectList.clear();
            Collection<RegisteredServer> collection = Game.getServerList();
            for (RegisteredServer registeredServer : collection) {
                int n2 = registeredServer.getOpenTime() / 60;
                MenuItem menuItem = new MenuItem(this.rb.getString("serveritem").replace("%1", registeredServer.getName()).replace("%2", String.valueOf(n2)), "joinDef " + registeredServer.getIp() + " " + registeredServer.getPort());
                menuItem.addMenuListener(this);
                this.selectList.add(menuItem);
            }
            this.selectList.add(this.back);
            this.sayString(this.rb.getString("servercount").replace("%d", String.valueOf(collection.size())));
            return;
        }
        if (((Menu)abstractMenuItem).getSelectedItem() == this.ip2) {
            this.ip2.setValue(this.getCurrentIP());
        }
        this.sayString(abstractMenuItem.getLongString());
        this.playSound("move");
    }

    @Override
    public void menuUpdated(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getLastUpdateString());
    }

    @Override
    public void menuHelp(AbstractMenuItem abstractMenuItem) {
        this.sayString(abstractMenuItem.getHelpString());
    }

    @Override
    public void menuError(AbstractMenuItem abstractMenuItem, int n) {
    }

    public String getCurrentIP() {
        if (currentIp != null) {
            return currentIp;
        }
        try {
            URL uRL = new URL("http://www.whatismyip.com/automation/n09230945.asp");
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine().trim();
            bufferedReader.close();
            inputStream.close();
            currentIp = string;
            return currentIp;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "127.0.0.1";
        }
    }
}

