/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import quentinc.menu.Menu;
import quentinc.menu.MenuListener;

public abstract class AbstractMenuItem
implements KeyListener {
    private List<MenuListener> listeners = null;
    protected Menu parent = null;
    private String ac;

    public void addMenuListener(MenuListener menuListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<MenuListener>(1);
        }
        this.listeners.add(menuListener);
    }

    public boolean removeMenuListener(MenuListener menuListener) {
        if (this.listeners == null) {
            return false;
        }
        return this.listeners.remove(menuListener);
    }

    public abstract String getLongString();

    public abstract String getShortString();

    public String getHelpString() {
        return "";
    }

    public String getLastUpdateString() {
        return this.getShortString();
    }

    public String toString() {
        return this.getLongString();
    }

    public boolean enterItem() {
        return true;
    }

    public boolean leaveItem() {
        return true;
    }

    public void setActionCommand(String string) {
        this.ac = string;
    }

    public String getActionCommand() {
        return this.ac;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.notifyClicked();
            keyEvent.consume();
        } else if (n == 27 || n == 37) {
            this.menuUpLevel();
            keyEvent.consume();
        } else if (n == 112) {
            this.notifyHelp();
        } else if (n == 155) {
            Menu.insertDown = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 155) {
            Menu.insertDown = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void menuUpLevel() {
        if (this.parent != null) {
            this.parent.setExpanded(false);
            this.parent.notifySelectionChanged(-1);
        }
    }

    protected void notifyClicked() {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuClicked(this);
        }
    }

    protected void notifyUpdated() {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuUpdated(this);
        }
    }

    protected void notifyHelp() {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuHelp(this);
        }
    }

    protected void notifyChanged() {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuChanged(this);
        }
    }

    protected void notifySelectionChanged(int n) {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuSelectionChanged(this, n);
        }
    }

    protected void notifyError(int n) {
        if (this.listeners == null) {
            return;
        }
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuError(this, n);
        }
    }

    protected AbstractMenuItem getsel() {
        return this;
    }
}

