/*
 * Decompiled with CFR 0.152.
 */
package quentinc.menu;

import java.awt.event.KeyEvent;
import quentinc.menu.MenuItem;

public class SpinMenuItem
extends MenuItem {
    private int value = 50;
    private int min = 0;
    private int max = 100;
    private int step1 = 1;
    private int step2 = 10;
    private String format = "%d";
    private String tmpInput = "";
    private long tmpInputTime = 0L;
    private static final int TIMEOUT = 500;
    private static String help = "Use left and right arrow keys to adjust the value, and use page down and page up to adjust more quickly. You can also directly enter a numeric value.";

    public SpinMenuItem(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5) {
        super(string, string2);
        this.format = string3;
        this.min = n;
        this.max = n3;
        this.value = n2;
        this.step1 = n4;
        this.step2 = n5;
    }

    public int getValue() {
        return this.value;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getSmallStep() {
        return this.step1;
    }

    public int getBigStep() {
        return this.step2;
    }

    public String getFormat() {
        return this.format;
    }

    public void setMin(int n) {
        this.min = n;
    }

    public void setMax(int n) {
        this.max = n;
    }

    public void setSmallStep(int n) {
        this.step1 = n;
    }

    public void setBigStep(int n) {
        this.step2 = n;
    }

    public void setValue(int n) {
        if (n > this.max) {
            n = this.max;
        }
        if (n < this.min) {
            n = this.min;
        }
        this.value = n;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public String getShortString() {
        return String.format(this.format, this.value, this.max, this.min, (int)Math.round(100.0 * (double)this.value / (double)(this.max - this.min)));
    }

    @Override
    public String getLongString() {
        return super.getLongString() + " : " + this.getShortString();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (n == 37) {
            this.setValue(this.getValue() - this.step1);
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 39) {
            this.setValue(this.getValue() + this.step1);
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 34) {
            this.setValue(this.getValue() - this.step2);
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 33) {
            this.setValue(this.getValue() + this.step2);
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 36) {
            this.setValue(this.getMin());
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 35) {
            this.setValue(this.getMax());
            this.notifyChanged();
            keyEvent.consume();
        } else if (n == 8 || n >= 48 && n <= 57) {
            char c;
            long l = System.currentTimeMillis();
            if (l - this.tmpInputTime > 500L) {
                this.tmpInput = "";
            }
            if ((c = keyEvent.getKeyChar()) >= '0' && c <= '9') {
                this.tmpInput = this.tmpInput + c;
            } else if (this.tmpInput.length() >= 1) {
                this.tmpInput = this.tmpInput.substring(0, this.tmpInput.length() - 1);
            }
            this.tmpInputTime = l;
            if (this.tmpInput.length() >= 1) {
                this.setValue(Integer.parseInt(this.tmpInput));
            }
            this.notifyChanged();
            keyEvent.consume();
        }
        if (!keyEvent.isConsumed()) {
            super.keyPressed(keyEvent);
        }
    }

    public static void setStrings(String string) {
        help = string;
    }

    @Override
    public String getHelpString() {
        return help;
    }
}

