/*
 * Decompiled with CFR 0.152.
 */
package quentinc.accessibility;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;
import quentinc.accessibility.Speech;

public class CLI
extends Speech {
    private BufferedWriter bw = null;
    private Process proc;
    private String interruptChar = "!";

    public CLI(Properties properties) throws IOException {
        this(properties.getProperty("command", "speech"), properties.getProperty("interruptChar", "!"), properties.getProperty("encoding", "utf8"));
    }

    public CLI(String string, String string2, String string3) throws IOException {
        this.interruptChar = string2;
        this.proc = Runtime.getRuntime().exec(string);
        this.bw = new BufferedWriter(new OutputStreamWriter(this.proc.getOutputStream(), string3));
    }

    public void close() throws IOException {
        this.bw.close();
        this.proc.destroy();
    }

    public void finalize() throws IOException {
        this.close();
    }

    @Override
    public boolean sayString(String string) {
        return this.sayString(string, false);
    }

    public boolean stopSpeech() {
        return this.sayString("", true);
    }

    @Override
    public boolean sayString(String string, boolean bl) {
        if (bl && !string.startsWith(this.interruptChar)) {
            string = this.interruptChar + string;
        } else if (!bl && string.startsWith(this.interruptChar)) {
            string = " " + string;
        }
        try {
            this.bw.write(string);
            this.bw.write("\r\n");
            this.bw.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean isAvailable() {
        return true;
    }
}

