/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import quentinc.audio.AudioManager;
import quentinc.audio.Mixer;
import quentinc.audio.SampleChannel;

public class Sample {
    protected short[] data;
    protected int sampleRate;
    protected int length;
    protected int limit;
    protected boolean mono;
    protected Object res = null;
    protected float defaultVol = 1.0f;

    public float getDefaultVolume() {
        return this.defaultVol;
    }

    public Sample setDefaultVolume(float f) {
        this.defaultVol = f;
        return this;
    }

    protected Sample(Object object, short[] sArray, int n, boolean bl) {
        this.res = object;
        this.data = sArray;
        this.sampleRate = n;
        this.mono = bl;
        this.length = this.data.length - 2 >> (this.mono ? 0 : 1);
        this.limit = -1;
    }

    protected SampleChannel createChannel(Mixer mixer, boolean bl) {
        SampleChannel sampleChannel = new SampleChannel(mixer, this, bl);
        sampleChannel.setVolume(this.defaultVol);
        return sampleChannel;
    }

    public static Sample load(URL uRL) throws IOException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
            Sample sample = Sample.load(audioInputStream);
            sample.res = uRL;
            audioInputStream.close();
            return sample;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException();
        }
    }

    public static Sample load(File file) throws IOException {
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
            Sample sample = Sample.load(audioInputStream);
            sample.res = file;
            audioInputStream.close();
            return sample;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException();
        }
    }

    public static Sample load(InputStream inputStream) throws IOException {
        try {
            return Sample.load(AudioSystem.getAudioInputStream(inputStream));
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            throw new IOException("Unsupported audio file");
        }
    }

    public static Sample load(AudioInputStream audioInputStream) throws IOException {
        int n;
        audioInputStream = AudioManager.getInstance().translateStream(audioInputStream);
        int n2 = (int)audioInputStream.getFormat().getSampleRate();
        boolean bl = audioInputStream.getFormat().getChannels() == 1;
        boolean bl2 = audioInputStream.getFormat().getSampleSizeInBits() == 8;
        boolean bl3 = audioInputStream.getFormat().isBigEndian();
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = audioInputStream.read(byArray, 0, byArray.length)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        short[] sArray = new short[byArray.length / (bl2 ? 1 : 2) + 2];
        n = 0;
        for (int i = 0; i < sArray.length - 2; ++i) {
            short s = bl2 ? (short)(byArray[n++] << 8) : (short)((byArray[n++] << (bl3 ? 8 : 0)) + (byArray[n++] << (bl3 ? 0 : 8)));
            sArray[i] = s;
        }
        sArray[sArray.length - 1] = sArray[1];
        sArray[sArray.length - 2] = sArray[0];
        return new Sample(null, sArray, n2, bl);
    }
}

