/*
 * Decompiled with CFR 0.152.
 */
package quentinc.audio;

import quentinc.audio.AudioManager;
import quentinc.audio.InternStream;
import quentinc.audio.Sample;

class SampleChannel
extends InternStream {
    private static final int SHIFT = 14;
    private static final int SHIFT_VAL = 16384;
    private static final int SHIFT_MASK = 16383;
    protected int pan = 16384;
    protected int rate = 16384;
    protected int pos = 0;
    protected int posf = 0;
    protected int totalpos = 0;
    protected boolean loop = false;
    protected boolean paused = false;
    protected Sample sample;

    public SampleChannel(InternStream internStream, Sample sample, boolean bl) {
        this.parent = internStream;
        this.sample = sample;
        this.loop = bl;
        this.setPitch(1.0f);
        this.setVol(32768);
    }

    @Override
    public float getPan() {
        if (!this.sample.mono) {
            throw new UnsupportedOperationException("Pan can't be get or set for stereo sounds.");
        }
        return (float)this.pan / 32768.0f;
    }

    @Override
    public SampleChannel setPan(float f) {
        this.pan = (int)(f * 32768.0f);
        return this;
    }

    @Override
    public float getPitch() {
        return (float)(this.rate * this.sample.sampleRate) / (16384.0f * AudioManager.getInstance().getSampleRate());
    }

    @Override
    public SampleChannel setPitch(float f) {
        this.rate = (int)(16384.0f * f * (float)this.sample.sampleRate / AudioManager.getInstance().getSampleRate());
        return this;
    }

    @Override
    public float getPosition() {
        return 1.0f * (float)this.pos / (float)this.sample.sampleRate;
    }

    @Override
    public SampleChannel setPosition(float f) {
        int n = (int)(f * (float)this.sample.sampleRate);
        if (n >= this.sample.length) {
            throw new IllegalArgumentException(String.format("Position out of range : %f given but maximum = %f", Float.valueOf(f), Float.valueOf(this.getLength())));
        }
        this.pos = n;
        return this;
    }

    @Override
    public float getLength() {
        return 1.0f * (float)this.sample.length / (float)this.sample.sampleRate;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    @Override
    public SampleChannel setLoop(boolean bl) {
        this.loop = bl;
        return this;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public SampleChannel setPaused(boolean bl) {
        this.paused = bl;
        return this;
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    public boolean stop() {
        this.loop = false;
        this.pos = this.sample.length;
        this.hookStop();
        return true;
    }

    @Override
    public int mix(short[] sArray, int n, int n2) {
        int n3;
        if (this.paused) {
            return n2;
        }
        if (!this.loop && this.pos >= this.sample.length) {
            return -1;
        }
        if (this.vol <= 0) {
            this.posf += this.rate * n2;
            this.pos += this.posf >> 14;
            this.posf &= 0x3FFF;
            if (this.pos >= this.sample.length) {
                this.hookSampleEnd();
            }
            return n2;
        }
        for (n3 = n; n3 < n + n2; ++n3) {
            int n4;
            int n5;
            if (this.sample.mono) {
                int n6 = ((this.sample.data[this.pos] * (16384 - this.posf) >> 14) + (this.sample.data[this.pos + 1] * this.posf >> 14)) * this.vol >> 16;
                n5 = sArray[n3] + (n6 * this.pan >> 15);
                n4 = sArray[n3 + 1] + (n6 * (32768 - this.pan) >> 15);
                if (n4 > Short.MAX_VALUE) {
                    n4 = Short.MAX_VALUE;
                }
                if (n5 > Short.MAX_VALUE) {
                    n5 = Short.MAX_VALUE;
                }
                if (n4 < -32767) {
                    n4 = -32767;
                }
                if (n5 < -32767) {
                    n5 = -32767;
                }
                sArray[n3++] = (short)n4;
                sArray[n3] = (short)n5;
            } else {
                n4 = ((this.sample.data[this.pos << 1] * (16384 - this.posf) >> 14) + (this.sample.data[this.pos + 1 << 1] * this.posf >> 14)) * this.vol >> 16;
                n5 = ((this.sample.data[(this.pos << 1) + 1] * (16384 - this.posf) >> 14) + (this.sample.data[(this.pos + 1 << 1) + 1] * this.posf >> 14)) * this.vol >> 16;
                n5 += sArray[n3 + 1];
                if ((n4 += sArray[n3]) > Short.MAX_VALUE) {
                    n4 = Short.MAX_VALUE;
                }
                if (n5 > Short.MAX_VALUE) {
                    n5 = Short.MAX_VALUE;
                }
                if (n4 < -32767) {
                    n4 = -32767;
                }
                if (n5 < -32767) {
                    n5 = -32767;
                }
                sArray[n3++] = (short)n4;
                sArray[n3] = (short)n5;
            }
            this.posf += this.rate;
            while (this.sample.limit >= 0 && this.pos < this.sample.limit && this.pos + (this.posf >> 14) > this.sample.limit) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            this.pos += this.posf >> 14;
            this.posf &= 0x3FFF;
            if (this.pos >= this.sample.length && !this.hookSampleEnd()) break;
        }
        return n3 - n;
    }

    protected void hookStop() {
    }

    protected void hookLimit() {
    }

    protected boolean hookSampleEnd() {
        if (this.loop) {
            this.pos -= this.sample.length;
        }
        return this.loop;
    }
}

